IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Contratos_Horarios_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Contratos_Horarios_Generar 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Contratos_Horarios_Generar] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 
/*Variables recibidas por parmetro a traves del JSON*/
DECLARE @pFlagUsarTrans		TINYINT
DECLARE @pModoDebug			TINYINT
DECLARE @pId_Contrato		INT
DECLARE @pId_Prod_Familia_Horario	VARCHAR(14)
DECLARE @pItem				INT

/*				*/
SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Contrato			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Contrato')), 0)
SET @pItem					= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Item')), 1)
SET @pId_Prod_Familia_Horario= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Producto')), 0)
/*FIN Variables recibidas por parmetro a traves del JSON*/


/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/
DECLARE @Id_Contrato_Prod_Horario INT
/*Fin de Declaraciones Variables Locales */



BEGIN TRY

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Contratos_Horarios_Generar'
	END
	
	/*===================================================================*/


	/*===================================================================*/

	
	IF(@pId_Contrato = 0)  RAISERROR ('Id_Contrato can not be zero.', 16,  1 )

		
	/*===================================================================*/
	
	

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Inserto en Contratos Prod.'
	END
	
	IF(@pId_Contrato <> 0)
	BEGIN
		SET @Id_Contrato_Prod_Horario	= ISNULL((SELECT MAX(Id_Contrato_Prod_Horario) FROM Contratos_Prod_Horarios), 0) + 1
		INSERT INTO Contratos_Prod_Horarios(Id_Contrato_Prod_Horario, Id_Contrato, Item, Id_Prod_Familia_Horario)
		VALUES (@Id_Contrato_Prod_Horario,@pId_Contrato, @pItem,@pId_Prod_Familia_Horario)
	END


	
	/*===================================================================*/	
	
	SET @rtaMsjStored		=	'{' +
								dbo.CF_Json_ParsearVariable('id_contrato', @pId_Contrato, 'INT')  + ',' +
								'}'
								
	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,@pId_Contrato	AS ErrorLine		
			,@rtaMsjStored	AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Contratos_Horarios_Generar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END

	RETURN 9999
END CATCH

RETURN 0

--Ejemplo de uso
--EXEC CPJ_Contratos_Horarios_Generar '{"FlagUsarTrans":"0", "ModoDebug":"1", "Id_Contrato":"593401", "Item":"1", "Id_Prod_Familia_Horario":"1"}'


